function [Aproj_final,Vc_final]=mzPCA_processed(finaldata);  
%This program will take your final data and perform PCA.  It will calculate
%all the principal components and make a Log Scree Graph.  Here you will
%look for an "elbow".  Everything above the elbow is likely important and
%everything after the elbow is likely noise.  While not precisely accurate,
%this approach can give you a ball-park idea of how many PCs are
%meaningful.  For further discussion on the Scree Graph, see the 
%book Principal Component Analysis by I.T. Jolliffe, section 6.1.3.  Note:
%This command automatically mean-centers the data.

%INPUTS
%finaldata - this is your loged, background subtracted, Gaussian filtered,
%aligned, normalized (if desired) data structure. The number of rows should
%equal the number of pixels and the number of columns should equal the
%number of m/z values in each scan, remembering that the data may be
%trimmed and/or downsampled.

%OUTPUTS
%Aproj - Scores of the principal components for each pixel. The number of
%rows has some number of principal components calculated (20 for easy
%viewing, see below) and the number of columns equals the number of pixels.
%The first row corresponds to the scores for the principal component within
%the first column of Vc and so on.

%Vc - These are the spectral trends of your data for each principal
%component.  By default, this only outputs the first 20. Some or all of
%these principal components may be relevant. If you wish to change this to
%a higher number to include more principal components (in case 20 is not
%enough)change the number 20 in command line 45 below.

%The commands below mean center the data prior to PCA analysis:
meandata=mean(finaldata);

[a,b]=size(finaldata);
for x=1:a
    finaldata(x,:)=finaldata(x,:)-meandata;
end
clear a b

%The svd command actually performs PCA:
[u,s,v]=svd(finaldata');
%the next command extracts the spectral trends.  By default, I choose 20.
%If you want/need more, feel free to change the number 20 to whatever you
%wish in the command line below:
Vc_final=u(:,(1:20));

%Aproj contains your PC scores.  The next command line allows me to
%generate them:
Aproj_final=Vc_final'*finaldata';

%Finally, I make the log scree plot using the s matrix from svd.
figure
plot(log10(diag(s)),'*')
xlabel('PC #','FontSize',16)
ylabel('Relative Importance','FontSize',16)
set(gca,'FontSize',16)
set(gcf, 'color', 'white');
set(gca,'ytick',[])
set(gca,'yticklabel',[])

